<?php
/**
 * PostFinance Checkout SDK
 *
 * This library allows to interact with the PostFinance Checkout payment service.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


namespace PostFinanceCheckout\Sdk\Model;
use \PostFinanceCheckout\Sdk\ObjectSerializer;

/**
 * ShopifySubscriptionProductCreate model
 *
 * @category    Class
 * @description 
 * @package     PostFinanceCheckout\Sdk
 * @author      wallee AG
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 */
class ShopifySubscriptionProductCreate extends AbstractShopifySubscriptionProductUpdate 
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShopifySubscriptionProduct.Create';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'product_id' => 'string',
        'product_legacy_id' => 'string',
        'product_variant_id' => 'string',
        'product_variant_legacy_id' => 'string',
        'shop' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'product_id' => null,
        'product_legacy_id' => null,
        'product_variant_id' => null,
        'product_variant_legacy_id' => null,
        'shop' => 'int64'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'product_id' => 'productId',
        'product_legacy_id' => 'productLegacyId',
        'product_variant_id' => 'productVariantId',
        'product_variant_legacy_id' => 'productVariantLegacyId',
        'shop' => 'shop'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'product_id' => 'setProductId',
        'product_legacy_id' => 'setProductLegacyId',
        'product_variant_id' => 'setProductVariantId',
        'product_variant_legacy_id' => 'setProductVariantLegacyId',
        'shop' => 'setShop'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'product_id' => 'getProductId',
        'product_legacy_id' => 'getProductLegacyId',
        'product_variant_id' => 'getProductVariantId',
        'product_variant_legacy_id' => 'getProductVariantLegacyId',
        'shop' => 'getShop'
    ];

    


    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        parent::__construct($data);

        
        $this->container['product_id'] = isset($data['product_id']) ? $data['product_id'] : null;
        
        $this->container['product_legacy_id'] = isset($data['product_legacy_id']) ? $data['product_legacy_id'] : null;
        
        $this->container['product_variant_id'] = isset($data['product_variant_id']) ? $data['product_variant_id'] : null;
        
        $this->container['product_variant_legacy_id'] = isset($data['product_variant_legacy_id']) ? $data['product_variant_legacy_id'] : null;
        
        $this->container['shop'] = isset($data['shop']) ? $data['shop'] : null;
        
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = parent::listInvalidProperties();

        if ($this->container['product_legacy_id'] === null) {
            $invalidProperties[] = "'product_legacy_id' can't be null";
        }
        if ($this->container['product_variant_legacy_id'] === null) {
            $invalidProperties[] = "'product_variant_legacy_id' can't be null";
        }
        if ($this->container['shop'] === null) {
            $invalidProperties[] = "'shop' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes + parent::swaggerTypes();
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats + parent::swaggerFormats();
    }


    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return parent::attributeMap() + self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return parent::setters() + self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return parent::getters() + self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }

    

    /**
     * Gets product_id
     *
     * @return string
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string $product_id The ID of the Shopify product that is enabled to be ordered as subscription.
     *
     * @return $this
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }
    

    /**
     * Gets product_legacy_id
     *
     * @return string
     */
    public function getProductLegacyId()
    {
        return $this->container['product_legacy_id'];
    }

    /**
     * Sets product_legacy_id
     *
     * @param string $product_legacy_id The legacy ID of the Shopify product that is enabled to be ordered as subscription.
     *
     * @return $this
     */
    public function setProductLegacyId($product_legacy_id)
    {
        $this->container['product_legacy_id'] = $product_legacy_id;

        return $this;
    }
    

    /**
     * Gets product_variant_id
     *
     * @return string
     */
    public function getProductVariantId()
    {
        return $this->container['product_variant_id'];
    }

    /**
     * Sets product_variant_id
     *
     * @param string $product_variant_id 
     *
     * @return $this
     */
    public function setProductVariantId($product_variant_id)
    {
        $this->container['product_variant_id'] = $product_variant_id;

        return $this;
    }
    

    /**
     * Gets product_variant_legacy_id
     *
     * @return string
     */
    public function getProductVariantLegacyId()
    {
        return $this->container['product_variant_legacy_id'];
    }

    /**
     * Sets product_variant_legacy_id
     *
     * @param string $product_variant_legacy_id 
     *
     * @return $this
     */
    public function setProductVariantLegacyId($product_variant_legacy_id)
    {
        $this->container['product_variant_legacy_id'] = $product_variant_legacy_id;

        return $this;
    }
    

    /**
     * Gets shop
     *
     * @return int
     */
    public function getShop()
    {
        return $this->container['shop'];
    }

    /**
     * Sets shop
     *
     * @param int $shop 
     *
     * @return $this
     */
    public function setShop($shop)
    {
        $this->container['shop'] = $shop;

        return $this;
    }
    
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


